'
' Instances of this class model the state of a temperature sensor.
'
Public Class TemperatureSensor
    Inherits Sensor
    Private myZone As SecurityZone = Nothing

    ' The security zone that this sensor's is part of.
    Public Property Zone() As SecurityZone
        Get
            Return myZone
        End Get
        Set(ByVal Value As SecurityZone)
            myZone = Value
        End Set
    End Property 'Zone

    ' When the temperature sensor associated with this object
    ' observes a different temperature this method is called.
    '
    ' measurement - The new temperature.
    Public Overrides Sub Notify(ByVal measurement As Integer)
        Zone.Notify(measurement, Me)
    End Sub 'Notify
End Class 'TemperatureSensor
